/*
 * Decompiled with CFR 0.152.
 */
package org.oasis_open.contextserver.api;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.xml.bind.annotation.XmlTransient;
import org.oasis_open.contextserver.api.Item;
import org.oasis_open.contextserver.api.Profile;
import org.oasis_open.contextserver.api.Session;
import org.oasis_open.contextserver.api.TimestampedItem;
import org.oasis_open.contextserver.api.actions.ActionPostExecutor;

public class Event
extends Item
implements TimestampedItem {
    private static final long serialVersionUID = -1096874942838593575L;
    public static final String ITEM_TYPE = "event";
    public static final String HTTP_REQUEST_ATTRIBUTE = "http_request";
    public static final String HTTP_RESPONSE_ATTRIBUTE = "http_response";
    private String eventType;
    private String sessionId = null;
    private String profileId = null;
    private Date timeStamp;
    private Map<String, Object> properties;
    private transient Profile profile;
    private transient Session session;
    private transient List<ActionPostExecutor> actionPostExecutors;
    private String scope;
    private Item source;
    private Item target;
    private transient boolean persistent = true;
    private transient Map<String, Object> attributes = new LinkedHashMap<String, Object>();

    public Event() {
    }

    public Event(String eventType, Session session, Profile profile, String scope, Item source, Item target, Date timestamp) {
        super(UUID.randomUUID().toString());
        this.eventType = eventType;
        this.profile = profile;
        this.session = session;
        this.profileId = profile.getItemId();
        this.scope = scope;
        this.source = source;
        this.target = target;
        if (session != null) {
            this.sessionId = session.getItemId();
        }
        this.timeStamp = timestamp;
        this.properties = new HashMap<String, Object>();
        this.actionPostExecutors = new ArrayList<ActionPostExecutor>();
    }

    public Event(String eventType, Session session, Profile profile, String scope, Item source, Item target, Map<String, Object> properties, Date timestamp) {
        this(eventType, session, profile, scope, source, target, timestamp);
        if (properties != null) {
            this.properties = properties;
        }
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public String getProfileId() {
        return this.profileId;
    }

    public void setProfileId(String profileId) {
        this.profileId = profileId;
    }

    public String getEventType() {
        return this.eventType;
    }

    @Override
    public Date getTimeStamp() {
        return this.timeStamp;
    }

    @XmlTransient
    public Profile getProfile() {
        return this.profile;
    }

    public void setProfile(Profile profile) {
        this.profile = profile;
    }

    @XmlTransient
    public Session getSession() {
        return this.session;
    }

    public void setSession(Session session) {
        this.session = session;
    }

    @XmlTransient
    public boolean isPersistent() {
        return this.persistent;
    }

    public void setPersistent(boolean persistent) {
        this.persistent = persistent;
    }

    @XmlTransient
    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public void setProperty(String name, Object value) {
        this.properties.put(name, value);
    }

    public Object getProperty(String name) {
        return this.properties.get(name);
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    @Override
    public String getScope() {
        return this.scope;
    }

    @Override
    public void setScope(String scope) {
        this.scope = scope;
    }

    public Item getSource() {
        return this.source;
    }

    public void setSource(Item source) {
        this.source = source;
    }

    public Item getTarget() {
        return this.target;
    }

    public void setTarget(Item target) {
        this.target = target;
    }

    @XmlTransient
    public List<ActionPostExecutor> getActionPostExecutors() {
        return this.actionPostExecutors;
    }

    public void setActionPostExecutors(List<ActionPostExecutor> actionPostExecutors) {
        this.actionPostExecutors = actionPostExecutors;
    }
}

