/*
 * Decompiled with CFR 0.152.
 */
package org.oasis_open.contextserver.api;

import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Item
implements Serializable {
    private static final Logger logger = LoggerFactory.getLogger((String)Item.class.getName());
    private static final long serialVersionUID = 7446061538573517071L;
    protected String itemId;
    protected String itemType;
    protected String scope;

    public Item() {
        try {
            this.itemType = (String)this.getClass().getField("ITEM_TYPE").get(null);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            logger.error("Item implementations must provide a public String constant named ITEM_TYPE to uniquely identify this Item for the persistence service.", (Throwable)e);
        }
    }

    public Item(String itemId) {
        this();
        this.itemId = itemId;
    }

    public String getItemId() {
        return this.itemId;
    }

    public void setItemId(String itemId) {
        this.itemId = itemId;
    }

    public String getItemType() {
        return this.itemType;
    }

    public void setItemType(String itemType) {
        this.itemType = itemType;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Item item = (Item)o;
        return !(this.itemId != null ? !this.itemId.equals(item.itemId) : item.itemId != null);
    }

    public int hashCode() {
        return this.itemId != null ? this.itemId.hashCode() : 0;
    }
}

