/*
 * Decompiled with CFR 0.152.
 */
package org.oasis_open.contextserver.api;

import java.util.Set;
import java.util.TreeSet;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;
import org.oasis_open.contextserver.api.PluginType;

public class Tag
implements PluginType,
Comparable<Tag> {
    private Set<Tag> subTags = new TreeSet<Tag>();
    private String id;
    private String nameKey;
    private String descriptionKey;
    private String parentId;
    private double rank = 0.0;
    private long pluginId;
    private boolean hidden = false;

    public Tag() {
    }

    public Tag(String id, String nameKey, String descriptionKey, String parentId) {
        this.id = id;
        this.nameKey = nameKey;
        this.descriptionKey = descriptionKey;
        this.parentId = parentId;
    }

    public String getId() {
        return this.id;
    }

    public String getNameKey() {
        if (this.nameKey == null) {
            this.nameKey = "tag." + this.id + ".name";
        }
        return this.nameKey;
    }

    public String getDescriptionKey() {
        if (this.descriptionKey == null) {
            this.descriptionKey = "tag." + this.id + ".description";
        }
        return this.descriptionKey;
    }

    @XmlElement(name="parent")
    public String getParentId() {
        return this.parentId;
    }

    public Set<Tag> getSubTags() {
        return this.subTags;
    }

    public void setSubTags(Set<Tag> subTags) {
        this.subTags = subTags;
    }

    public double getRank() {
        return this.rank;
    }

    public void setRank(double rank) {
        this.rank = rank;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    @Override
    @XmlTransient
    public long getPluginId() {
        return this.pluginId;
    }

    @Override
    public void setPluginId(long pluginId) {
        this.pluginId = pluginId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Tag that = (Tag)o;
        return !(this.id != null ? !this.id.equals(that.id) : that.id != null);
    }

    public int hashCode() {
        int result = this.id != null ? this.id.hashCode() : 0;
        return result;
    }

    @Override
    public int compareTo(Tag otherRank) {
        int rankCompare = Double.compare(this.rank, otherRank.rank);
        if (rankCompare != 0) {
            return rankCompare;
        }
        return this.id.compareTo(otherRank.id);
    }
}

